implementation module controlvalidate


//	Clean Object I/O library, version 1.1


import	StdInt, StdList, StdFunc
import	ospicture, oswindow
import	commondef, windowhandle, wstate


//	Validate the title of a control.

validateControlTitle :: !String -> String
validateControlTitle string
	= RemoveSpecialChars OSControlTitleSpecialChars string


//	Validate the settings of a slider.

validateSliderState :: !SliderState -> SliderState
validateSliderState {sliderMin=sMin, sliderMax=sMax, sliderThumb=thumb}
	= {	sliderMin	= min`
	  ,	sliderMax	= max`
	  ,	sliderThumb	= SetBetween thumb min` max`
	  }
where
	min` = min sMin sMax
	max` = max sMin sMax


//	Validate the Look function to always erase the update area with a given colour before drawing.

validateLook :: !Look -> Look
validateLook look
	= validLook
where
	validLook :: SelectState !UpdateState -> *Picture -> *Picture
	validLook selectState updateState=:{updArea}
		= (look selectState updateState) o eraseUpdateArea
	where
		eraseUpdateArea :: !*Picture -> *Picture
		eraseUpdateArea picture
			# (curcolour,picture)
						= accpictpencolour picture
			# picture	= setpictpencolour White picture		// PA: should be erase
			# picture	= StateMap2 (\r p->pictfillrect (RectangleToRect r) p) updArea picture
			# picture	= setpictpencolour curcolour picture
			= picture

//	Collect all Ids of the given [WElementHandle].

getWElementControlIds :: ![WElementHandle .ls .ps] -> (![Id],![WElementHandle .ls .ps])
getWElementControlIds [itemH:itemHs]
	# (ids1,itemH)	= getWElementIds itemH
	# (ids2,itemHs)	= getWElementControlIds itemHs
	= (ids1++ids2,[itemH:itemHs])
where
	getWElementIds :: !(WElementHandle .ls .ps) -> (![Id],!WElementHandle .ls .ps)
	getWElementIds (WListLSHandle itemHs)
		# (ids,itemHs)	= getWElementControlIds itemHs
		= (ids,WListLSHandle itemHs)
	getWElementIds (WExtendLSHandle wExH=:{wExtendItems=itemHs})
		# (ids,itemHs)	= getWElementControlIds itemHs
		= (ids,WExtendLSHandle {wExH & wExtendItems=itemHs})
	getWElementIds (WChangeLSHandle wChH=:{wChangeItems=itemHs})
		# (ids,itemHs)	= getWElementControlIds itemHs
		= (ids,WChangeLSHandle {wChH & wChangeItems=itemHs})
	getWElementIds (WItemHandle itemH)
		# (ids,itemH)	= getWElementIds` itemH
		= (ids,WItemHandle itemH)
	where
		getWElementIds` :: !(WItemHandle .ls .ps) -> (![Id],!WItemHandle .ls .ps)
		getWElementIds` itemH=:{wItemId,wItems}
			# (ids,itemHs)	= getWElementControlIds wItems
			# itemH			= {itemH & wItems=itemHs}
			| isJust wItemId
			= ([fromJust wItemId:ids],itemH)
			= (ids,itemH)
getWElementControlIds _
	= ([],[])


//	Collect all Ids of the given [WElementHandle`].

getWElementControlIds` :: ![WElementHandle`] -> [Id]
getWElementControlIds` [itemH:itemHs]
	= getWElementIds itemH ++ getWElementControlIds` itemHs
where
	getWElementIds :: !WElementHandle` -> [Id]
	getWElementIds (WRecursiveHandle` itemHs _)
		= getWElementControlIds` itemHs
	getWElementIds (WItemHandle` itemH)
		= getWElementIds` itemH
	where
		getWElementIds` :: !WItemHandle` -> [Id]
		getWElementIds` itemH=:{wItemId`,wItems`}
			# ids	= getWElementControlIds` wItems`
			| isJust wItemId`
			= [fromJust wItemId`:ids]
			= ids
getWElementControlIds` _
	= []


//	Id occurrence checks on [WElementHandle .ls .ps] and [WElementHandle`].

//	There are no duplicate (ControlId id) attributes:

noDuplicateControlIds :: ![WElementHandle .ls .ps] -> (!Bool,![WElementHandle .ls .ps])
noDuplicateControlIds itemHs
	# (ids,itemHs)	= getWElementControlIds itemHs
	= (noDuplicates ids, itemHs)

noDuplicateControlIds` :: ![WElementHandle`] -> Bool
noDuplicateControlIds` itemHs
	= noDuplicates (getWElementControlIds` itemHs)


//	The list of Ids does not occur in any (ControlId id) attribute:

disjointControlIds :: ![Id] ![WElementHandle .ls .ps] -> (!Bool,![WElementHandle .ls .ps])
disjointControlIds ids itemHs
	# (ids`,itemHs)	= getWElementControlIds itemHs
	= (disjointLists ids ids`,itemHs)

disjointControlIds` :: ![Id] ![WElementHandle`] -> Bool
disjointControlIds` ids itemHs
	= disjointLists ids (getWElementControlIds` itemHs)
